package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDEC;
import com.ejie.p06b.datatype.model.P06B39T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (05/07/2010)
 */
public class P06B39T00DAO {
	
	static private P06B39T00DAO instance = null;

	public static P06B39T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B39T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B39T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene un registro de la BD a partir de la clave primaria
    * @param numExp.
    *            parte de la clave primaria
    * @param ejer.
    *            parte de la clave primaria
    * @return un objeto P06B39T00Datatype o null si no se encuentra nada.
	* @throws Exception
    */
	public P06B39T00Datatype select(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B39T00DAO-select");
		P06B39T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B39T00Datatype();
	        	
	        	result.setEjercicio(lrst.getString(P06BTablas.P06B_P06B39_EJERCICIO));
	        	result.setNumExp(lrst.getString(P06BTablas.P06B_P06B39_NUMEXP));
				result.setVolTotIndPrimInter(lrst.getString(P06BTablas.P06B_P06B39_VOLTOTIND_PRIMINTER)==null?"":lrst.getString(P06BTablas.P06B_P06B39_VOLTOTIND_PRIMINTER));
				result.setVolTotIndComisDeven(lrst.getString(P06BTablas.P06B_P06B39_VOLTOTIND_COMISDEVEN)==null?"":lrst.getString(P06BTablas.P06B_P06B39_VOLTOTIND_COMISDEVEN));
				result.setVolTotIndHonorProf(lrst.getString(P06BTablas.P06B_P06B39_VOLTOTIND_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B39_VOLTOTIND_HONORPROF));
				result.setVolTotColPrimInter(lrst.getString(P06BTablas.P06B_P06B39_VOLTOTCOL_PRIMINTER)==null?"":lrst.getString(P06BTablas.P06B_P06B39_VOLTOTCOL_PRIMINTER));
				result.setVolTotColComisDeven(lrst.getString(P06BTablas.P06B_P06B39_VOLTOTCOL_COMISDEVEN)==null?"":lrst.getString(P06BTablas.P06B_P06B39_VOLTOTCOL_COMISDEVEN));
				result.setVolTotColHonorProf(lrst.getString(P06BTablas.P06B_P06B39_VOLTOTCOL_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B39_VOLTOTCOL_HONORPROF));
				result.setNuevaIndPrimInter(lrst.getString(P06BTablas.P06B_P06B39_NUEVAIND_PRIMINTER)==null?"":lrst.getString(P06BTablas.P06B_P06B39_NUEVAIND_PRIMINTER));
				result.setNuevaIndComisDeven(lrst.getString(P06BTablas.P06B_P06B39_NUEVAIND_COMISDEVEN)==null?"":lrst.getString(P06BTablas.P06B_P06B39_NUEVAIND_COMISDEVEN));
				result.setNuevaIndHonorProf(lrst.getString(P06BTablas.P06B_P06B39_NUEVAIND_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B39_NUEVAIND_HONORPROF));
				result.setNuevaColPrimInter(lrst.getString(P06BTablas.P06B_P06B39_NUEVACOL_PRIMINTER)==null?"":lrst.getString(P06BTablas.P06B_P06B39_NUEVACOL_PRIMINTER));
				result.setNuevaColComisDeven(lrst.getString(P06BTablas.P06B_P06B39_NUEVACOL_COMISDEVEN)==null?"":lrst.getString(P06BTablas.P06B_P06B39_NUEVACOL_COMISDEVEN));
				result.setNuevaColHonorProf(lrst.getString(P06BTablas.P06B_P06B39_NUEVACOL_HONORPROF)==null?"":lrst.getString(P06BTablas.P06B_P06B39_NUEVACOL_HONORPROF));
	        }
	        P06BLog.send(2,this, "Fin P06B39T00DAO-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}
	
	
	/**
    * Obtiene los datos para el informe resumen de la DEC asociados al ejercicio indicado
    * @param ejerDEC.
    *            ejercicio de la DEC
    * @param objInformeDEC.
    *            objeto donde actualizar los datos obtenidos en la select
	* @throws Exception
    */
	public void selectRamosVidaInformeDEC(String ejerDEC, P06BInformeDEC objInformeDEC,String tipoMed) throws Exception{
		P06BLog.send(2,this, "Inicio P06B39T00DAO-selectRamosVidaInformeDEC");
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_RAMOSVIDA_INFORMEDEC;
        
        //Dependiendo del tipo hacer una select u otra. Corredores: F, J, RF, RJ. Vinculados: AF, AJ. Operadores banca: OV.
        if(P06BConstantes.P06B_CORR.equals(tipoMed)){
        	sql += " AND " + " (" + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA+"-%' or " + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA+"-%' or " + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_JURIDICA+"-%' or " + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_FISICA+"-%')";
    	}else if(P06BConstantes.P06B_VINC.equals(tipoMed)){
    		sql += " AND " + " (" + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_AGENTEVINCULADO_FISICA+"-%' or " + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA+"-%')";
    	}else if(P06BConstantes.P06B_OBS.equals(tipoMed)){
    		sql += " AND " + " (" + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_OPERADORBANCA_VINCULADO+"-%' or " + P06BTablas.P06B_P06B39_NUMEXP + " like '"+P06BConstantes.P06B_OPERADORBANCA_EXCLUSIVO+"-%')";
    	}
        
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejerDEC.toUpperCase());
        	lrst = lstm.executeQuery();
        	
	        if (lrst.next()) {
	        	if(P06BConstantes.P06B_CORR.equals(tipoMed)){
	        		objInformeDEC.setPrimInterVolTotVidaCorrM2(lrst.getDouble("PRIMINTER_VOLTOT_VIDA"));
		        	objInformeDEC.setComisVolTotVidaCorrM2(lrst.getDouble("COMISDEVEN_VOLTOT_VIDA"));
		        	objInformeDEC.setPrimInterNuevaVidaCorrM2(lrst.getDouble("PRIMINTER_NUEVAPROD_VIDA"));
	        	}else if(P06BConstantes.P06B_VINC.equals(tipoMed)){
	        		objInformeDEC.setPrimInterVolTotVidaVincM2(lrst.getDouble("PRIMINTER_VOLTOT_VIDA"));
		        	objInformeDEC.setComisVolTotVidaVincM2(lrst.getDouble("COMISDEVEN_VOLTOT_VIDA"));
		        	objInformeDEC.setPrimInterNuevaVidaVincM2(lrst.getDouble("PRIMINTER_NUEVAPROD_VIDA"));
	        	}else if(P06BConstantes.P06B_OBS.equals(tipoMed)){
	        		objInformeDEC.setPrimInterVolTotVidaObsM2(lrst.getDouble("PRIMINTER_VOLTOT_VIDA"));
		        	objInformeDEC.setComisVolTotVidaObsM2(lrst.getDouble("COMISDEVEN_VOLTOT_VIDA"));
		        	objInformeDEC.setPrimInterNuevaVidaObsM2(lrst.getDouble("PRIMINTER_NUEVAPROD_VIDA"));
	        	}
	        }
	        P06BLog.send(2,this, "Fin P06B39T00DAO-selectRamosVidaInformeDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
	}
		
	
	/**
	    * Obtiene los datos para el informe resumen de la DEC asociados al ejercicio indicado
	    * @param ejerDEC.
	    *            ejercicio de la DEC
	    * @param objInformeOtroDEC.
	    *            objeto donde actualizar los datos obtenidos en la select
		* @throws Exception
	    */
		public void selectDatosInformeOtroDEC(String ejerDEC, P06BInformeOtroDEC objInformeOtroDEC) throws Exception{
			P06BLog.send(2,this, "Inicio P06B39T00DAO-selectDatosInformeOtroDEC");
			PreparedStatement lstm  = null;
	        ResultSet lrst  = null;
	        String sql = SELECT_DATOS_INFORMEOTRODEC;
	        String sTipoMediador;
	        
	        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
	        try {
	        	lstm = lconConexion.prepareStatement(sql);
	        	lstm.setString(1,ejerDEC.toUpperCase());
	        	lrst = lstm.executeQuery();
	        	
		        while (lrst.next()) {

	        		sTipoMediador = lrst.getString("TC");
		        	if(sTipoMediador.equals(P06BConstantes.P06B_CORREDORES_CTEEXP_FISICA)){
		        		objInformeOtroDEC.setD39_F1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD39_F2(lrst.getDouble("D2"));
		        		objInformeOtroDEC.setD39_F3(lrst.getDouble("D3"));
		        		objInformeOtroDEC.setD39_F4(lrst.getDouble("D4"));
		        		objInformeOtroDEC.setD39_F5(lrst.getDouble("D5"));
		        		objInformeOtroDEC.setD39_F6(lrst.getDouble("D6"));
		        	}else if(sTipoMediador.equals(P06BConstantes.P06B_CORREDORES_CTEEXP_JURIDICA)){
		        		objInformeOtroDEC.setD39_J1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD39_J2(lrst.getDouble("D2"));
		        		objInformeOtroDEC.setD39_J3(lrst.getDouble("D3"));
		        		objInformeOtroDEC.setD39_J4(lrst.getDouble("D4"));
		        		objInformeOtroDEC.setD39_J5(lrst.getDouble("D5"));
		        		objInformeOtroDEC.setD39_J6(lrst.getDouble("D6"));
		        	}else if(sTipoMediador.equals(P06BConstantes.P06B_AGENTEVINCULADO_CTEEXP_FISICA)){
		        		objInformeOtroDEC.setD39_AF1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD39_AF2(lrst.getDouble("D2"));
		        		objInformeOtroDEC.setD39_AF3(lrst.getDouble("D3"));
		        		objInformeOtroDEC.setD39_AF4(lrst.getDouble("D4"));
		        		objInformeOtroDEC.setD39_AF5(lrst.getDouble("D5"));
		        		objInformeOtroDEC.setD39_AF6(lrst.getDouble("D6"));
		        	}else if(sTipoMediador.equals(P06BConstantes.P06B_AGENTEVINCULADO_CTEEXP_JURIDICA)){
		        		objInformeOtroDEC.setD39_AJ1(lrst.getDouble("D1"));
		        		objInformeOtroDEC.setD39_AJ2(lrst.getDouble("D2"));
		        		objInformeOtroDEC.setD39_AJ3(lrst.getDouble("D3"));
		        		objInformeOtroDEC.setD39_AJ4(lrst.getDouble("D4"));
		        		objInformeOtroDEC.setD39_AJ5(lrst.getDouble("D5"));
		        		objInformeOtroDEC.setD39_AJ6(lrst.getDouble("D6"));
		        	}
		        }
		        P06BLog.send(2,this, "Fin P06B39T00DAO-selectDatosInformeOtroDEC");
		    } catch (SQLException e) {
		    	P06BLog.send(2,this, "error: " +e.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e;
		    }catch (Exception e2) {	 
	        	P06BLog.send(2,this, "error: " +e2.getMessage());
	        	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		        //Propago la excepcin
		        throw e2;
		    }finally {
		    	try {
	        		if(lrst!=null)
	        			lrst.close();
	        	}catch (Exception rse) {}
		        try {
		        	if(lstm!=null)
		        		lstm.close();
		        }catch (Exception sse) {}
		        try {
		        	if(lconConexion!=null)
		        		lconConexion.close();
		        }catch (Exception cse) {}
		    }
		}
			
		
	private static String SELECT_BY_PK =
		"SELECT " +	
		P06BTablas.P06B_P06B39_EJERCICIO + ", " + 
		P06BTablas.P06B_P06B39_NUMEXP + ", " + 
		P06BTablas.P06B_P06B39_VOLTOTIND_PRIMINTER + ", " + 
		P06BTablas.P06B_P06B39_VOLTOTIND_COMISDEVEN + ", " + 
		P06BTablas.P06B_P06B39_VOLTOTIND_HONORPROF + ", " + 
		P06BTablas.P06B_P06B39_VOLTOTCOL_PRIMINTER + ", " + 
		P06BTablas.P06B_P06B39_VOLTOTCOL_COMISDEVEN + ", " + 
		P06BTablas.P06B_P06B39_VOLTOTCOL_HONORPROF + ", " + 
		P06BTablas.P06B_P06B39_NUEVAIND_PRIMINTER + ", " + 
		P06BTablas.P06B_P06B39_NUEVAIND_COMISDEVEN + ", " + 
		P06BTablas.P06B_P06B39_NUEVAIND_HONORPROF + ", " + 
		P06BTablas.P06B_P06B39_NUEVACOL_PRIMINTER + ", " + 
		P06BTablas.P06B_P06B39_NUEVACOL_COMISDEVEN + ", " + 
		P06BTablas.P06B_P06B39_NUEVACOL_HONORPROF +
		" FROM "+ P06BTablas.P06B_P06B39T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B39_EJERCICIO + " = ? and " + P06BTablas.P06B_P06B39_NUMEXP + " = ?";
	
	
	private static String SELECT_RAMOSVIDA_INFORMEDEC =
		"SELECT NVL((sum(nvl("+P06BTablas.P06B_P06B39_VOLTOTIND_PRIMINTER+",0)) + sum(nvl("+P06BTablas.P06B_P06B39_VOLTOTCOL_PRIMINTER+",0))),0) as PRIMINTER_VOLTOT_VIDA," +
		" NVL((sum(nvl("+P06BTablas.P06B_P06B39_VOLTOTIND_COMISDEVEN+",0)) + sum(nvl("+P06BTablas.P06B_P06B39_VOLTOTCOL_COMISDEVEN+",0))),0) as COMISDEVEN_VOLTOT_VIDA," +
		" NVL((sum(nvl("+P06BTablas.P06B_P06B39_NUEVAIND_PRIMINTER+",0)) + sum(nvl("+P06BTablas.P06B_P06B39_NUEVACOL_PRIMINTER+",0))),0) as PRIMINTER_NUEVAPROD_VIDA" +	
		" FROM "+ P06BTablas.P06B_P06B39T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B39_EJERCICIO + " = ?";
	
	private static String SELECT_DATOS_INFORMEOTRODEC =
		"SELECT SUBSTR(" + P06BTablas.P06B_P06B39_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B39_NUMEXP + ", '-')-1) as TC, SUM(NVL(" +
		P06BTablas.P06B_P06B39_VOLTOTIND_PRIMINTER + ",0)+NVL(" + P06BTablas.P06B_P06B39_VOLTOTCOL_PRIMINTER + ",0)) as D1, SUM(NVL(" +
		P06BTablas.P06B_P06B39_VOLTOTIND_COMISDEVEN + ",0)+NVL(" + P06BTablas.P06B_P06B39_VOLTOTCOL_COMISDEVEN + ",0)) as D2, SUM(NVL(" +
		P06BTablas.P06B_P06B39_VOLTOTIND_HONORPROF + ",0)+NVL(" + P06BTablas.P06B_P06B39_VOLTOTCOL_HONORPROF + ",0)) as D3, SUM(NVL(" +
		P06BTablas.P06B_P06B39_NUEVAIND_PRIMINTER + ",0)+NVL(" + P06BTablas.P06B_P06B39_NUEVACOL_PRIMINTER + ",0)) as D4, SUM(NVL(" +
		P06BTablas.P06B_P06B39_NUEVAIND_COMISDEVEN + ",0)+NVL(" + P06BTablas.P06B_P06B39_NUEVACOL_COMISDEVEN + ",0)) as D5, SUM(NVL(" +
		P06BTablas.P06B_P06B39_NUEVAIND_HONORPROF + ",0)+NVL(" + P06BTablas.P06B_P06B39_NUEVACOL_HONORPROF + ",0)) as D6 FROM " +
		P06BTablas.P06B_P06B39T00_TABLA + " WHERE " + P06BTablas.P06B_P06B39_EJERCICIO + " = ? GROUP BY SUBSTR(" + P06BTablas.P06B_P06B39_NUMEXP + ", 0, INSTR(" + P06BTablas.P06B_P06B39_NUMEXP + ", '-')-1)";
	
}
